'use client';

import Header from '../../../components/Header';
import MobileHeader from '../../../components/MobileHeader';
import Footer from '../../../components/Footer';
import { useTranslations } from 'next-intl';
import { useState, useEffect } from 'react';
import Image from 'next/image';
import AnimatedText from '../../../components/AnimatedText';
import AnimatedElement from '../../../components/AnimatedElement';

export default function ReasonsToInvestPage() {
  const t = useTranslations('ReasonsToInvestPage');
  const tCommon = useTranslations('Common');
  const [isDesktop, setIsDesktop] = useState(false);

  useEffect(() => {
    const checkScreenSize = () => {
      setIsDesktop(window.innerWidth >= 1024);
    };

    checkScreenSize();
    window.addEventListener('resize', checkScreenSize);

    return () => window.removeEventListener('resize', checkScreenSize);
  }, []);

  if (isDesktop) {
    // Desktop Version
  return (
      <div className="flex w-full flex-col items-start bg-[#F5F1F0] font-roboto">
      {/* Header */}
        <div className="flex h-[65px] px-8 justify-between items-center w-full bg-white">
          <div className="flex max-w-[1376px] justify-between items-center flex-1 mx-auto">
            <Header />
        </div>
      </div>
      
      {/* Main Content */}
      <div className="w-full flex pb-[60px] flex-col justify-center items-center gap-[40px]">
        {/* Hero Section */}
        <div className="w-full flex flex-col justify-center items-center gap-[24px]">
          {/* Panorama Section */}
          <div className="w-full relative flex h-[597px] flex-col justify-end items-center gap-[24px] bg-gradient-to-b from-black/16 to-black/28">
            {/* Background Video */}
            <video 
              autoPlay 
              loop 
              muted
              playsInline 
              preload="auto" 
              className="absolute inset-0 w-full h-full object-cover"
            >
              <source src="/images/Reasons/Standard_Mode_let_the_clouds_move_and_the_wate (2).mp4" type="video/mp4" />
              Your browser does not support the video tag.
            </video>
            
            {/* Content */}
            <div className="flex max-w-[1376px] mx-auto flex-col items-start gap-[24px] flex-1 w-full relative z-10 p-[32px]">
              <div className="flex flex-col items-start gap-[12px] flex-1 w-full">
                <AnimatedText
                  as="h1"
                  animation="slideInUp"
                  delay={200}
                  className="w-full text-white text-center font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
                >
                  {t('title')}
                </AnimatedText>
              </div>
            </div>
          </div>
          
          {/* Description Section */}
          <div className="w-full flex px-[32px] flex-col justify-end items-center gap-[8px]">
            <div className="w-full max-w-[1376px] mx-auto">
              <div className="flex pl-[24px] flex-col items-start gap-[16px] border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={400}
                  className="max-w-[1344px] w-full text-black font-roboto text-[18px] font-light leading-[150%]"
                >
                {t('description')}
              </AnimatedText>
              </div>
            </div>
          </div>
        </div>

        {/* Card 1: Economic Growth and Future Prospects */}
        <div className="w-full flex max-w-[1440px] mx-auto px-[32px] items-stretch gap-[40px]">
          <AnimatedElement
            animation="slideInLeft"
            delay={200}
            className="flex flex-1"
          >
            <Image 
              src="/images/Reasons/14e0ca5dcf8f42469137884b3e6427ff40100133.jpg" 
              alt="Economic Growth"
              className="w-full h-full object-cover flex-1 self-stretch"
              width={672}
              height={1000}
            />
          </AnimatedElement>
          <div className="flex flex-col justify-center items-start gap-[32px] flex-1 min-h-0">
            <AnimatedText
              as="h2"
              animation="slideInRight"
              delay={400}
              className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('card1_title')}
            </AnimatedText>
            <div className="flex flex-col justify-center items-start gap-[16px] w-full">
              <AnimatedText
                as="h3"
                animation="slideInRight"
                delay={500}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card1_subtitle1')}
              </AnimatedText>
              <div className="flex pl-[24px] flex-col items-start gap-[16px] w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInRight"
                  delay={600}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card1_desc1')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-[16px] w-full">
              <AnimatedText
                as="h3"
                animation="slideInRight"
                delay={700}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card1_subtitle2')}
              </AnimatedText>
              <div className="flex pl-[24px] flex-col items-start gap-[16px] w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInRight"
                  delay={800}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card1_desc2')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-[16px] w-full">
              <AnimatedText
                as="h3"
                animation="slideInRight"
                delay={900}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card1_subtitle3')}
              </AnimatedText>
              <div className="flex pl-[24px] flex-col items-start gap-[16px] w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInRight"
                  delay={1000}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card1_desc3')}
                </AnimatedText>
              </div>
            </div>
          </div>
        </div>

        {/* Card 2: Thriving Tourism Sector */}
        <div className="w-full flex max-w-[1440px] mx-auto px-[32px] items-center gap-[40px]">
          <div className="flex flex-col justify-center items-start gap-[32px] flex-1">
            <AnimatedText
              as="h2"
              animation="slideInLeft"
              delay={400}
              className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('card2_title')}
            </AnimatedText>
            <div className="flex flex-col justify-center items-start gap-[16px] w-full">
              <AnimatedText
                as="h3"
                animation="slideInLeft"
                delay={500}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card2_subtitle1')}
              </AnimatedText>
              <div className="flex pl-[24px] flex-col items-start gap-[16px] w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInLeft"
                  delay={600}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card2_desc1')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-[16px] w-full">
              <AnimatedText
                as="h3"
                animation="slideInLeft"
                delay={700}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card2_subtitle2')}
              </AnimatedText>
              <div className="flex pl-[24px] flex-col items-start gap-[16px] w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInLeft"
                  delay={800}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card2_desc2')}
                </AnimatedText>
              </div>
            </div>
          </div>
          <AnimatedElement
            animation="slideInRight"
            delay={200}
            className="flex h-[672px] items-start gap-[8px] flex-1"
          >
            <Image 
              src="/images/Reasons/d4e33df6a2eb582e9273d0a8fe1aa145c74312c9.jpg" 
              alt="Tourism Sector"
              className="w-full h-full object-cover"
              width={672}
              height={672}
            />
          </AnimatedElement>
        </div>

        {/* Card 3: Ecotourism and Sustainable Development */}
        <div className="w-full flex max-w-[1440px] mx-auto px-[32px] items-center gap-[40px]">
          <AnimatedElement
            animation="slideInLeft"
            delay={200}
            className="flex h-[672px] items-start gap-[8px] flex-1"
          >
            <video 
              className="w-full h-full object-cover" 
              autoPlay 
              muted 
              loop 
              playsInline
            >
              <source src="/images/Reasons/10.mp4" type="video/mp4" />
              Your browser does not support the video tag.
            </video>
          </AnimatedElement>
          <div className="flex flex-col justify-center items-start gap-[32px] flex-1">
            <AnimatedText
              as="h2"
              animation="slideInRight"
              delay={400}
              className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('card3_title')}
            </AnimatedText>
            <div className="flex flex-col justify-center items-start gap-[16px] w-full">
              <AnimatedText
                as="h3"
                animation="slideInRight"
                delay={500}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card3_subtitle1')}
              </AnimatedText>
              <div className="flex pl-[24px] flex-col items-start gap-[16px] w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInRight"
                  delay={600}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card3_desc1')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-[16px] w-full">
              <AnimatedText
                as="h3"
                animation="slideInRight"
                delay={700}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card3_subtitle2')}
              </AnimatedText>
              <div className="flex pl-[24px] flex-col items-start gap-[16px] w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInRight"
                  delay={800}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card3_desc2')}
                </AnimatedText>
              </div>
            </div>
          </div>
        </div>

        {/* Card 4: Growing Demand for Luxury Real Estate */}
        <div className="w-full flex max-w-[1440px] mx-auto px-[32px] items-center gap-[40px]">
          <div className="flex flex-col justify-center items-start gap-[32px] flex-1">
            <AnimatedText
              as="h2"
              animation="slideInLeft"
              delay={400}
              className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('card4_title')}
            </AnimatedText>
            <div className="flex flex-col justify-center items-start gap-[16px] w-full">
              <AnimatedText
                as="h3"
                animation="slideInLeft"
                delay={500}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card4_subtitle1')}
              </AnimatedText>
              <div className="flex pl-[24px] flex-col items-start gap-[16px] w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInLeft"
                  delay={600}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card4_desc1')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-[16px] w-full">
              <AnimatedText
                as="h3"
                animation="slideInLeft"
                delay={700}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card4_subtitle2')}
              </AnimatedText>
              <div className="flex pl-[24px] flex-col items-start gap-[16px] w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInLeft"
                  delay={800}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card4_desc2')}
                </AnimatedText>
              </div>
            </div>
          </div>
          <AnimatedElement
            animation="slideInRight"
            delay={200}
            className="flex h-[672px] items-start gap-[8px] flex-1"
          >
            <Image 
              src="/images/Reasons/2a4868b2473f2dd3a409d8dc0260941a42d4e953.jpg" 
              alt="Luxury Real Estate"
              className="w-full h-full object-cover"
              width={672}
              height={672}
            />
          </AnimatedElement>
        </div>

        {/* Card 5: Accessibility for Foreign Investors */}
        <div className="w-full flex max-w-[1440px] mx-auto px-[32px] items-center gap-[40px]">
          <AnimatedElement
            animation="slideInLeft"
            delay={200}
            className="flex h-[672px] items-start gap-[8px] flex-1"
          >
            <Image 
              src="/images/Reasons/e4007d48af4e1fec54c9ea24fb8c6986edd641f8.jpg" 
              alt="Foreign Investors"
              className="w-full h-full object-cover"
              width={672}
              height={672}
            />
          </AnimatedElement>
          <div className="flex flex-col justify-center items-start gap-[32px] flex-1">
            <AnimatedText
              as="h2"
              animation="slideInRight"
              delay={400}
              className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('card5_title')}
            </AnimatedText>
            <div className="flex flex-col justify-center items-start gap-[16px] w-full">
              <AnimatedText
                as="h3"
                animation="slideInRight"
                delay={500}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card5_subtitle1')}
              </AnimatedText>
              <div className="flex pl-[24px] flex-col items-start gap-[16px] w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInRight"
                  delay={600}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card5_desc1')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-[16px] w-full">
              <AnimatedText
                as="h3"
                animation="slideInRight"
                delay={700}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card5_subtitle2')}
              </AnimatedText>
              <div className="flex pl-[24px] flex-col items-start gap-[16px] w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInRight"
                  delay={800}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card5_desc2')}
                </AnimatedText>
              </div>
            </div>
          </div>
        </div>

        {/* Card 6: Tax Advantages and Ease of Doing Business */}
        <div className="w-full flex max-w-[1440px] mx-auto px-[32px] items-center gap-[40px]">
          <div className="flex flex-col justify-center items-start gap-[32px] flex-1">
            <AnimatedText
              as="h2"
              animation="slideInLeft"
              delay={400}
              className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('card6_title')}
            </AnimatedText>
            <div className="flex flex-col justify-center items-start gap-[16px] w-full">
              <AnimatedText
                as="h3"
                animation="slideInLeft"
                delay={500}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card6_subtitle1')}
              </AnimatedText>
              <div className="flex pl-[24px] flex-col items-start gap-[16px] w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInLeft"
                  delay={600}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card6_desc1')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-[16px] w-full">
              <AnimatedText
                as="h3"
                animation="slideInLeft"
                delay={700}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card6_subtitle2')}
              </AnimatedText>
              <div className="flex pl-[24px] flex-col items-start gap-[16px] w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInLeft"
                  delay={800}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card6_desc2')}
                </AnimatedText>
              </div>
            </div>
          </div>
          <AnimatedElement
            animation="slideInRight"
            delay={200}
            className="flex h-[672px] items-start gap-[8px] flex-1"
          >
            <video 
              className="w-full h-full object-cover" 
              autoPlay 
              muted 
              loop 
              playsInline
            >
              <source src="/images/Reasons/5.mp4" type="video/mp4" />
              Your browser does not support the video tag.
            </video>
          </AnimatedElement>
        </div>

        {/* Card 7: Economically Advantageous Real Estate Prices */}
        <div className="w-full flex max-w-[1440px] mx-auto px-[32px] items-center gap-[40px]">
          <AnimatedElement
            animation="slideInLeft"
            delay={200}
            className="flex h-[672px] items-start gap-[8px] flex-1"
          >
            <Image 
              src="/images/Reasons/2147f3c4f98a1f4896ee2a925c80e8c364500dea.png" 
              alt="Real Estate Prices"
              className="w-full h-full object-cover"
              width={672}
              height={672}
            />
          </AnimatedElement>
          <div className="flex flex-col justify-center items-start gap-[32px] flex-1">
            <AnimatedText
              as="h2"
              animation="slideInRight"
              delay={400}
              className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('card7_title')}
            </AnimatedText>
            <div className="flex flex-col justify-center items-start gap-[16px] w-full">
              <AnimatedText
                as="h3"
                animation="slideInRight"
                delay={500}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card7_subtitle1')}
              </AnimatedText>
              <div className="flex pl-[24px] flex-col items-start gap-[16px] w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInRight"
                  delay={600}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card7_desc1')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-[16px] w-full">
              <AnimatedText
                as="h3"
                animation="slideInRight"
                delay={700}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card7_subtitle2')}
              </AnimatedText>
              <div className="flex pl-[24px] flex-col items-start gap-[16px] w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInRight"
                  delay={800}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card7_desc2')}
                </AnimatedText>
              </div>
            </div>
          </div>
        </div>
      </div>

        <Footer />
      </div>
    );
  }

  // Mobile Version (375px)
  return (
    <div className="flex w-full flex-col items-start bg-[#F5F1F0] font-roboto">
      {/* Mobile Header */}
      <div className="flex h-[65px] py-[5px] pl-3 pr-0 justify-between items-center w-full bg-white">
        <MobileHeader />
      </div>

      {/* Mobile Main Content */}
      <div className="flex pb-[60px] flex-col justify-center items-center gap-[40px] w-full">
        {/* Mobile Hero Section */}
        <div className="flex flex-col justify-center items-center gap-[24px] w-full">
          {/* Mobile Panorama Section */}
          <div className="flex h-[846px] px-3 py-8 flex-col justify-end items-start gap-6 w-full bg-gradient-to-b from-black/16 to-black/28 relative">
            {/* Background Video */}
            <video 
              autoPlay 
              loop 
              muted
              playsInline 
              preload="auto" 
              className="absolute inset-0 w-full h-full object-cover"
            >
              <source src="/images/Reasons/Standard_Mode_let_the_clouds_move_and_the_wate (2).mp4" type="video/mp4" />
              Your browser does not support the video tag.
            </video>
            
            {/* Content */}
            <div className="flex max-w-[1376px] flex-col items-start gap-6 flex-1 w-full relative z-10">
              <div className="flex flex-col items-start gap-3 flex-1 w-full">
                <h1 className="w-full text-white text-center font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]">
                  {t('title')}
                </h1>
              </div>
            </div>
          </div>
          
          {/* Mobile Description Section */}
          <div className="flex px-3 flex-col justify-end items-center gap-2 w-full">
            <div className="flex pl-6 flex-col items-start gap-4 border-l border-black/20 w-full">
              <p className="w-full text-black font-roboto text-[18px] font-light leading-[150%]">
                {t('description')}
              </p>
            </div>
          </div>
        </div>

        {/* Mobile Card 1: Economic Growth and Future Prospects */}
        <div className="flex max-w-[1440px] px-3 flex-col justify-center items-start gap-[40px] w-full">
          <AnimatedElement
            animation="slideInUp"
            delay={200}
            className="flex h-[351px] items-start gap-2 w-full"
          >
            <Image 
              src="/images/Reasons/14e0ca5dcf8f42469137884b3e6427ff40100133.jpg" 
              alt="Economic Growth"
              className="w-full h-full object-cover"
              width={351}
              height={351}
            />
          </AnimatedElement>
          <div className="flex w-[351px] flex-col justify-center items-start gap-8">
            <AnimatedText
              as="h2"
              animation="slideInUp"
              delay={400}
              className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('card1_title')}
            </AnimatedText>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={500}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card1_subtitle1')}
              </AnimatedText>
              <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={600}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card1_desc1')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={700}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card1_subtitle2')}
              </AnimatedText>
              <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={800}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card1_desc2')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={900}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card1_subtitle3')}
              </AnimatedText>
              <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={1000}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card1_desc3')}
                </AnimatedText>
              </div>
            </div>
          </div>
        </div>

        {/* Mobile Card 2: Thriving Tourism Sector */}
        <div className="flex max-w-[1440px] px-3 flex-col justify-center items-start gap-[40px] w-full">
          <AnimatedElement
            animation="slideInUp"
            delay={200}
            className="flex h-[351px] items-start gap-2 w-full"
          >
            <Image 
              src="/images/Reasons/d4e33df6a2eb582e9273d0a8fe1aa145c74312c9.jpg" 
              alt="Tourism Sector"
              className="w-full h-full object-cover"
              width={351}
              height={351}
            />
          </AnimatedElement>
          <div className="flex flex-col justify-center items-start gap-8 w-full">
            <AnimatedText
              as="h2"
              animation="slideInUp"
              delay={400}
              className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('card2_title')}
            </AnimatedText>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={500}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card2_subtitle1')}
              </AnimatedText>
              <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={600}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card2_desc1')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={700}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card2_subtitle2')}
              </AnimatedText>
              <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={800}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card2_desc2')}
                </AnimatedText>
              </div>
            </div>
          </div>
        </div>

        {/* Mobile Card 3: Ecotourism and Sustainable Development */}
        <div className="flex max-w-[1440px] px-3 flex-col justify-center items-start gap-[40px] w-full">
          <AnimatedElement
            animation="slideInUp"
            delay={200}
            className="flex h-[351px] items-start gap-2 w-full"
          >
            <video 
              className="w-full h-full object-cover" 
              autoPlay 
              muted 
              loop 
              playsInline
            >
              <source src="/images/Reasons/10.mp4" type="video/mp4" />
              Your browser does not support the video tag.
            </video>
          </AnimatedElement>
          <div className="flex flex-col justify-center items-start gap-8 w-full">
            <AnimatedText
              as="h2"
              animation="slideInUp"
              delay={400}
              className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('card3_title')}
            </AnimatedText>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={500}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card3_subtitle1')}
              </AnimatedText>
              <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={600}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card3_desc1')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={700}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card3_subtitle2')}
              </AnimatedText>
              <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={800}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card3_desc2')}
                </AnimatedText>
              </div>
            </div>
          </div>
        </div>

        {/* Mobile Card 4: Growing Demand for Luxury Real Estate */}
        <div className="flex max-w-[1440px] px-3 flex-col justify-center items-start gap-[40px] w-full">
          <AnimatedElement
            animation="slideInUp"
            delay={200}
            className="flex h-[351px] items-start gap-2 w-full"
          >
            <Image 
              src="/images/Reasons/2a4868b2473f2dd3a409d8dc0260941a42d4e953.jpg" 
              alt="Luxury Real Estate"
              className="w-full h-full object-cover"
              width={351}
              height={351}
            />
          </AnimatedElement>
          <div className="flex flex-col justify-center items-start gap-8 w-full">
            <AnimatedText
              as="h2"
              animation="slideInUp"
              delay={400}
              className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('card4_title')}
            </AnimatedText>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={500}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card4_subtitle1')}
              </AnimatedText>
              <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={600}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card4_desc1')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={700}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card4_subtitle2')}
              </AnimatedText>
              <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={800}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card4_desc2')}
                </AnimatedText>
              </div>
            </div>
          </div>
        </div>

        {/* Mobile Card 5: Accessibility for Foreign Investors */}
        <div className="flex max-w-[1440px] px-3 flex-col justify-center items-start gap-[40px] w-full">
          <AnimatedElement
            animation="slideInUp"
            delay={200}
            className="flex h-[351px] items-start gap-2 w-full"
          >
            <Image 
              src="/images/Reasons/e4007d48af4e1fec54c9ea24fb8c6986edd641f8.jpg" 
              alt="Foreign Investors"
              className="w-full h-full object-cover"
              width={351}
              height={351}
            />
          </AnimatedElement>
          <div className="flex flex-col justify-center items-start gap-8 w-full">
            <AnimatedText
              as="h2"
              animation="slideInUp"
              delay={400}
              className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('card5_title')}
            </AnimatedText>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={500}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card5_subtitle1')}
              </AnimatedText>
              <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={600}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card5_desc1')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={700}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card5_subtitle2')}
              </AnimatedText>
              <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={800}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card5_desc2')}
                </AnimatedText>
              </div>
            </div>
          </div>
        </div>

        {/* Mobile Card 6: Tax Advantages and Ease of Doing Business */}
        <div className="flex max-w-[1440px] px-3 flex-col justify-center items-start gap-[40px] w-full">
          <AnimatedElement
            animation="slideInUp"
            delay={200}
            className="flex h-[351px] items-start gap-2 w-full"
          >
            <video 
              className="w-full h-full object-cover" 
              autoPlay 
              muted 
              loop 
              playsInline
            >
              <source src="/images/Reasons/5.mp4" type="video/mp4" />
              Your browser does not support the video tag.
            </video>
          </AnimatedElement>
          <div className="flex flex-col justify-center items-start gap-8 w-full">
            <AnimatedText
              as="h2"
              animation="slideInUp"
              delay={400}
              className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]"
            >
              {t('card6_title')}
            </AnimatedText>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={500}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card6_subtitle1')}
              </AnimatedText>
              <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={600}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card6_desc1')}
                </AnimatedText>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <AnimatedText
                as="h3"
                animation="slideInUp"
                delay={700}
                className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]"
              >
                {t('card6_subtitle2')}
              </AnimatedText>
              <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={800}
                  className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]"
                >
                  {t('card6_desc2')}
                </AnimatedText>
              </div>
            </div>
          </div>
        </div>

        {/* Mobile Card 7: Economically Advantageous Real Estate Prices */}
        <div className="flex max-w-[1440px] px-3 flex-col justify-center items-start gap-[40px] w-full">
          <div className="flex h-[351px] items-start gap-2 w-full">
            <Image 
              src="/images/Reasons/2147f3c4f98a1f4896ee2a925c80e8c364500dea.png" 
              alt="Real Estate Prices"
              className="w-full h-full object-cover"
              width={351}
              height={351}
            />
          </div>
          <div className="flex flex-col justify-center items-start gap-8 w-full">
            <h2 className="w-full text-[#1C1C1C] font-roboto text-[40px] font-light leading-[115%] tracking-[-1.2px]">
              {t('card7_title')}
            </h2>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <h3 className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]">
                {t('card7_subtitle1')}
              </h3>
              <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                <p className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]">
                  {t('card7_desc1')}
                </p>
              </div>
            </div>
            <div className="flex flex-col justify-center items-start gap-4 w-full">
              <h3 className="w-full text-[#1C1C1C] font-roboto text-[24px] font-light leading-[130%]">
                {t('card7_subtitle2')}
              </h3>
              <div className="flex pl-6 flex-col items-start gap-4 w-full border-l border-black/20">
                <p className="w-full text-[#1C1C1C] font-roboto text-[18px] font-light leading-[150%]">
                  {t('card7_desc2')}
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
      
      <Footer />
    </div>
  );
}
